/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplybackpacks.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.network.NetworkEvent;

public class ToggleMessageMessage {
    private final boolean enabled;

    public ToggleMessageMessage(boolean enabled) {
        this.enabled = enabled;
    }

    public static ToggleMessageMessage decode(FriendlyByteBuf buffer) {
        boolean en = buffer.readBoolean();
        return new ToggleMessageMessage(en);
    }

    public static void encode(ToggleMessageMessage message, FriendlyByteBuf buffer) {
        buffer.writeBoolean(message.enabled);
    }

    public static void handle(ToggleMessageMessage message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isClient()) {
            ctx.get().enqueueWork(() -> Minecraft.m_91087_().f_91074_.m_5661_((Component)new TextComponent(I18n.m_118938_((String)(message.enabled ? "simplybackpacks.autopickupenabled" : "simplybackpacks.autopickupdisabled"), (Object[])new Object[0])), true));
        }
        ctx.get().setPacketHandled(true);
    }
}

